/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat.profile;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.creeperhost.minetogether.lib.chat.ChatState;
import net.creeperhost.minetogether.lib.chat.message.Message;
import net.creeperhost.minetogether.lib.chat.message.MessageComponent;
import net.creeperhost.minetogether.lib.chat.request.ProfileResponse;
import net.creeperhost.minetogether.lib.chat.util.HashLength;
import net.creeperhost.minetogether.lib.util.AbstractWeakNotifiable;
import net.creeperhost.minetogether.repack.net.covers1624.quack.collection.StreamableIterable;
import net.creeperhost.minetogether.repack.net.covers1624.quack.gson.JsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Profile
extends AbstractWeakNotifiable<ProfileEvent> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Message> sentMessages = new LinkedList<Message>();
    private final ChatState chatState;
    final String initialHash;
    private ImmutableSet<String> aliases;
    @Nullable
    private String fullHash;
    @Nullable
    private String ircHash;
    private String displayName;
    @Nullable
    private String friendCode;
    @Nullable
    private String friendName;
    private boolean hasAccount;
    private boolean isBanned;
    private boolean isPremium;
    private boolean isFriend;
    private boolean isMuted;
    boolean isOnline;
    private boolean stale = true;
    private boolean updating = false;
    @Nullable
    private String packId = "";
    private Supplier<String> nameSupplier = () -> "";
    public boolean newProfileWhoDis;

    Profile(ChatState chatState, String initialHash) {
        this.chatState = chatState;
        this.initialHash = initialHash;
        if (HashLength.FULL.matches(initialHash)) {
            this.fullHash = initialHash;
            this.isMuted = chatState.mutedUserList.isUserMuted(this.fullHash);
            this.aliases = Profile.computeAllAliases(this.fullHash);
            this.ircHash = HashLength.MEDIUM.format(this.fullHash);
        } else {
            HashSet<String> aliases = new HashSet<String>();
            aliases.add(initialHash);
            if (initialHash.startsWith("MT")) {
                String sub = initialHash.substring(2);
                assert (StreamableIterable.of(HashLength.values()).anyMatch(e -> e.matches(sub)));
                aliases.add(sub);
            }
            this.aliases = ImmutableSet.copyOf(aliases);
        }
        boolean startsWithMT = initialHash.startsWith("MT");
        String hash = startsWithMT ? initialHash.substring(2) : initialHash;
        this.displayName = HashLength.matchesAny(hash) ? "User#" + hash.substring(0, 5) : hash;
    }

    public void unmute() {
        if (!this.isMuted) {
            return;
        }
        if (this.fullHash == null) {
            LOGGER.warn("Full hash not available when trying to unmute user.");
            return;
        }
        this.isMuted = false;
        this.chatState.mutedUserList.unmuteUser(this.fullHash);
        this.fire(new ProfileEvent(EventType.UNMUTED, this));
    }

    public void mute() {
        if (this.isMuted) {
            return;
        }
        if (this.fullHash == null) {
            LOGGER.warn("Full hash not available when trying to mute user.");
            return;
        }
        this.isMuted = true;
        this.chatState.mutedUserList.muteUser(this.fullHash);
        this.fire(new ProfileEvent(EventType.MUTED, this));
    }

    public void banned() {
        if (this.isBanned) {
            return;
        }
        this.isBanned = true;
        for (Message message : this.sentMessages) {
            message.setMessageOverride(MessageComponent.MESSAGE_DELETED);
        }
        this.fire(new ProfileEvent(EventType.BANNED, this));
    }

    public void unbanned() {
        if (!this.isBanned) {
            return;
        }
        this.isBanned = false;
        for (Message message : this.sentMessages) {
            message.setMessageOverride(null);
        }
        this.fire(new ProfileEvent(EventType.UNBANNED, this));
    }

    public void addSentMessage(Message message) {
        this.sentMessages.add(message);
    }

    public void setFriend(String name) {
        this.isFriend = true;
        this.friendName = name;
        this.fire(new ProfileEvent(EventType.FRIEND_ADD, this));
    }

    void removeFriend() {
        this.isFriend = false;
        this.friendName = null;
        this.fire(new ProfileEvent(EventType.FRIEND_REMOVE, this));
    }

    public void markStale() {
        this.stale = true;
        this.newProfileWhoDis = false;
    }

    public void setPack(Supplier<String> realName) {
        this.nameSupplier = realName;
        this.packId = null;
    }

    public String getPackId() {
        if (this.packId == null) {
            String realName = this.nameSupplier.get();
            if (StringUtils.isNotEmpty((CharSequence)realName) && realName.startsWith("{") && realName.endsWith("}")) {
                try {
                    JsonObject obj = JsonUtils.parseRaw(realName).getAsJsonObject();
                    String packId = JsonUtils.getString(obj, "p", null);
                    if (packId != null && !packId.equals("-1")) {
                        this.packId = packId;
                        return packId;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("Failed to parse realName: '{}'", (Object)realName);
                }
            }
            this.packId = "";
        }
        return this.packId;
    }

    public boolean isOnSamePack(Profile other) {
        return !this.getPackId().isEmpty() && this.getPackId().equals(other.getPackId());
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getFriendCode() {
        return Objects.requireNonNull(this.friendCode);
    }

    public boolean hasFriendName() {
        return this.friendName != null;
    }

    public String getFriendName() {
        return Objects.requireNonNull(this.friendName);
    }

    public String getFullHash() {
        return Objects.requireNonNull(this.fullHash, "Profile not updated yet.");
    }

    @Nullable
    public String getIrcName() {
        return this.ircHash;
    }

    public boolean hasAccount() {
        return this.hasAccount;
    }

    public boolean isBanned() {
        return this.isBanned;
    }

    public boolean isPremium() {
        return this.isPremium;
    }

    public boolean isFriend() {
        return this.isFriend;
    }

    public boolean isMuted() {
        return this.isMuted;
    }

    public boolean isOnline() {
        return this.isOnline;
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public boolean isStale() {
        return this.stale;
    }

    Consumer<ProfileResponse.ProfileData> onStartUpdating() {
        assert (!this.updating);
        this.updating = true;
        return p -> {
            String initialWithoutMT;
            this.fullHash = p.getLongHash();
            String string = initialWithoutMT = this.initialHash.startsWith("MT") ? this.initialHash.substring(2) : this.initialHash;
            if (!this.fullHash.startsWith(initialWithoutMT)) {
                LOGGER.error("Full hash does not start with initial hash! Full: {}, Initial: {}", (Object)this.fullHash, (Object)initialWithoutMT);
            }
            this.aliases = Profile.computeAllAliases(this.fullHash);
            this.ircHash = HashLength.MEDIUM.format(this.fullHash);
            this.displayName = p.getDisplay();
            this.friendCode = p.getFriendCode();
            this.hasAccount = p.hasAccount();
            this.isPremium = p.isPremium();
            this.fire(new ProfileEvent(EventType.FULL_PROFILE, this));
            this.updating = false;
            this.stale = false;
        };
    }

    public static ImmutableSet<String> computeAllAliases(String fullHash) {
        return StreamableIterable.of(HashLength.values()).flatMap(e -> Arrays.asList(e.format(fullHash), "MT" + e.format(fullHash))).toImmutableSet();
    }

    public static enum EventType {
        MUTED,
        UNMUTED,
        FRIEND_ADD,
        FRIEND_REMOVE,
        BANNED,
        UNBANNED,
        FULL_PROFILE,
        FRIEND_REQUEST;


        public boolean canChangeName() {
            return this == FULL_PROFILE || this == FRIEND_ADD || this == FRIEND_REMOVE;
        }
    }

    public static class ProfileEvent {
        public final EventType type;
        public final Profile profile;
        @Nullable
        public final Object data;

        public ProfileEvent(EventType type, Profile profile) {
            this(type, profile, null);
        }

        public ProfileEvent(EventType type, Profile profile, @Nullable Object data) {
            this.type = type;
            this.profile = profile;
            this.data = data;
        }
    }
}

